function plottemphum(sensdat, floc)
% plots temperature on on axis and humidity on other

x1min = min(sensdat(:,1));
x1max = max(sensdat(:,1));
y1min = min(sensdat(:,2));
y1max = max(sensdat(:,2));
y2min = min(sensdat(:,3));
y2max = max(sensdat(:,3));

% round to nearest hour (down or up)
xxmin=(round(x1min*24-0.5))/24;
xxmax=(round(x1max*24+0.5))/24;

xlim manual;
[ax,p1,p2] = plotyy(sensdat(:,1), sensdat(:,2), sensdat(:,1), sensdat(:,3));
ylim(ax(1), [round(y1min-0.5) round(y1max+0.5)]);
ylim(ax(2), [round(y2min-0.5) round(y2max+0.5)]);
%p1.Color = 'b';
%p2.Color = 'r';
set(ax(1), 'YTick', round(y1min-0.5):round(y1max+0.5));
set(ax(2), 'YTick', round(y2min-0.5):round(y2max+0.5));
% tried to set tick spacing on x axis to hourly, but no effect ... so far
%set(ax(1), 'XTick', xxmin:1/24:xxmax);
%set(ax(2), 'XTick', xxmin:1/24:xxmax);
box(ax(1),'off');

title(['Sensor Location:  '  floc], 'Interpreter','none');
ylabel(ax(1),'Temperature (\circC)') % label left y-axis
ylabel(ax(2),'Humidity (%RH)') % label right y-axis
xlabel(ax(2),'Time') % label x-axis

datetick(ax(1), 'x', 'yyyy-mm-dd HH:MM:SS');
datetick(ax(2), 'x', 'yyyy-mm-dd HH:MM:SS');

ax(1).XTickLabelRotation = 45;

ax(1).XMinorTick = 'on';
ax(1).YMinorTick = 'on';
ax(2).YMinorTick = 'on';
ax(1).XGrid = 'on';
grid minor
xlim(ax(1), [xxmin xxmax]);
xlim(ax(2), [xxmin xxmax]);